<?php
$page = 'about';
$title = 'About Us - Vinayaka Electronics';
include 'includes/header.php';
?>

<section class="page-header">
    <div class="container">
        <h1>About Us</h1>
        <p>Discover Our Journey Towards a Sustainable Future</p>
    </div>
</section>

<section class="about-intro">
    <div class="container">
        <div class="about-content">
            <h2>Welcome to Vinayaka Electronics</h2>
            <p class="lead">Founded on the principles of innovation and sustainability, Vinayaka Electronics has emerged as a leading force in the solar PV industry. With a legacy rooted in cutting-edge technology, we have positioned ourselves as a reliable partner, dedicated to providing tailored solar solutions that transcend conventional energy boundaries.</p>
            <p>Discover the story behind our commitment to excellence and our journey towards creating a more sustainable future.</p>
        </div>
    </div>
</section>

<section class="vision-mission">
    <div class="container">
        <div class="vm-grid">
            <div class="vm-card">
                <div class="vm-icon">👁️</div>
                <h2>Our Vision</h2>
                <p class="vm-tagline">"Technology for Humanity"</p>
                <p>Our vision is a world where clean, renewable energy is not just a choice but a necessity. We aspire to be pioneers in the renewable energy sector, driving the adoption of solar PV solutions through technological advancements and a steadfast commitment to environmental responsibility.</p>
                <p>Join us on a journey towards a brighter, cleaner, and more sustainable future.</p>
            </div>

            <div class="vm-card">
                <div class="vm-icon">🎯</div>
                <h2>Our Mission</h2>
                <p>Vinayaka Electronics is on a mission to revolutionize the way we harness solar energy. Our commitment extends beyond providing solar PV solutions; it encompasses designing and engineering innovative, efficient, and affordable energy alternatives.</p>
                <p>We strive to empower individuals, businesses, and communities to take control of their energy needs and contribute to a more sustainable planet.</p>
            </div>
        </div>
    </div>
</section>

<section class="what-we-do">
    <div class="container">
        <h2>What We Do</h2>
        <p class="section-subtitle">As your trusted solar power solution provider, we offer a diverse range of products and services</p>

        <div class="services-list">
            <div class="service-item">
                <h3>☀️ Solar Solutions</h3>
                <ul>
                    <li>Cutting-edge solar modules and inverters</li>
                    <li>Reliable switch gears and mounting solutions</li>
                    <li>Roof top solar installations</li>
                    <li>Ground mounted solar systems</li>
                    <li>Solar street lighting systems</li>
                </ul>
            </div>

            <div class="service-item">
                <h3>🔋 Energy Storage</h3>
                <ul>
                    <li>Automobile batteries</li>
                    <li>Exide inverter batteries</li>
                    <li>Home UPS inverters</li>
                    <li>Li-ion batteries</li>
                    <li>Battery chargers</li>
                </ul>
            </div>

            <div class="service-item">
                <h3>💧 Water Solutions</h3>
                <ul>
                    <li>Solar water heaters</li>
                    <li>Solar heat pumps</li>
                    <li>Water purification systems</li>
                    <li>Solar pump sets</li>
                </ul>
            </div>

            <div class="service-item">
                <h3>⚙️ Additional Services</h3>
                <ul>
                    <li>Scientific service center</li>
                    <li>Job-oriented training programs</li>
                    <li>Solar for petrol bunks</li>
                    <li>CCTV cameras and security systems</li>
                    <li>Audio-visual equipment</li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="why-choose-us">
    <div class="container">
        <h2>Why Choose Us</h2>
        <div class="reasons-grid">
            <div class="reason-card">
                <div class="reason-icon">💡</div>
                <h3>Innovation and Technology</h3>
                <p>At Vinayaka Electronics, innovation is our driving force. We constantly embrace the latest technologies, ensuring that our customers benefit from state-of-the-art solutions.</p>
            </div>

            <div class="reason-card">
                <div class="reason-icon">✓</div>
                <h3>Quality Components</h3>
                <p>Our commitment to excellence is unwavering. We provide high-quality solar modules, inverters, and components that meet the highest industry standards.</p>
            </div>

            <div class="reason-card">
                <div class="reason-icon">👥</div>
                <h3>Customer-Centric Approach</h3>
                <p>Your unique needs are our priority. We take a personalized approach, delivering bespoke solutions that not only meet but exceed your expectations.</p>
            </div>

            <div class="reason-card">
                <div class="reason-icon">🤝</div>
                <h3>Long-Term Partnerships</h3>
                <p>Our enduring partnerships with major solar module and inverter manufacturers reflect our commitment to reliability and consistency.</p>
            </div>

            <div class="reason-card">
                <div class="reason-icon">🏆</div>
                <h3>Experience Since 2006</h3>
                <p>With over 15 years of experience, we bring proven expertise and industry knowledge to every project we undertake.</p>
            </div>

            <div class="reason-card">
                <div class="reason-icon">🌍</div>
                <h3>Environmental Responsibility</h3>
                <p>We are committed to reducing carbon footprints and promoting sustainable energy practices for a better tomorrow.</p>
            </div>
        </div>
    </div>
</section>

<section class="leadership">
    <div class="container">
        <h2>Our Leadership</h2>
        <div class="leader-card">
            <h3>Smt. Navya Veeresh Gonal</h3>
            <p class="leader-title">Managing Director</p>
            <p class="leader-bio">Leading Vinayaka Electronics with a vision of "Technology for Humanity", Smt. Navya Veeresh Gonal has been instrumental in establishing the company as a trusted name in solar energy solutions across Karnataka. Under her leadership, the company has expanded its services to include not just solar products, but also training programs for unemployed youth and comprehensive service solutions for the community.</p>
        </div>
    </div>
</section>

<section class="cta-section">
    <div class="container">
        <h2>Ready to Partner With Us?</h2>
        <p>Explore our solutions and start your journey towards energy independence</p>
        <div class="cta-buttons">
            <a href="solar-calculator.php" class="btn btn-primary">Calculate Solar Savings</a>
            <a href="contact.php" class="btn btn-secondary">Get in Touch</a>
        </div>
    </div>
</section>

<?php include 'includes/footer.php'; ?>
