<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($title) ? $title : 'Vinayaka Electronics - Solar Solutions'; ?></title>
    <meta name="description" content="Vinayaka Electronics - Leading solar energy solutions provider in Vijayapura, Karnataka. Solar water heaters, photovoltaic systems, heat pumps, and more.">
    <meta name="keywords" content="solar energy, solar panels, solar water heater, Vijayapura, Karnataka, renewable energy">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <img src="public/vinayaka_electronics_logo_.jpg" alt="Vinayaka Electronics" class="nav-logo">
            </div>
            <button class="nav-toggle" onclick="toggleMenu()">
                <span></span>
                <span></span>
                <span></span>
            </button>
            <ul class="nav-menu" id="navMenu">
                <li><a href="index.php" class="<?php echo ($page == 'home') ? 'active' : ''; ?>">Home</a></li>
                <li><a href="about.php" class="<?php echo ($page == 'about') ? 'active' : ''; ?>">About Us</a></li>
                <li><a href="company-profile.php" class="<?php echo ($page == 'profile') ? 'active' : ''; ?>">Company Profile</a></li>
                <li><a href="solar-calculator.php" class="<?php echo ($page == 'calculator') ? 'active' : ''; ?>">Solar Calculator</a></li>
                <li><a href="contact.php" class="<?php echo ($page == 'contact') ? 'active' : ''; ?>">Contact Us</a></li>
            </ul>
        </div>
    </nav>

    <script>
        function toggleMenu() {
            const navMenu = document.getElementById('navMenu');
            navMenu.classList.toggle('active');
        }
    </script>
